varying vec2 f_texcoord;

uniform sampler2D texture;
uniform float factor;


void main(void)
{
	vec3 colorResult = texture2D(texture, f_texcoord).rgb;

	const float brightnessAdapt = 0.7;
	vec3 sepia1 = vec3(0.2, 0.05, 0.0) * brightnessAdapt;
	vec3 sepia2 = vec3(1.0, 0.90, 0.5) * brightnessAdapt;
	vec3 sepiaD = vec3(0.3, 0.59, 0.11);
	float sepiaMix = dot(sepiaD, colorResult);
	vec3 colorSepia = mix(sepia1, sepia2, sepiaMix);

	colorResult = mix(colorResult, colorSepia, factor);

	gl_FragColor = vec4(colorResult, 1.0);
}
